<?php

function nominate_topic_off($forumid = 0, $postinfo = array(), $bloginfo = array(), $threadfirstpostid = 0, $this_script = ''){

	global $vbulletin;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_nominate_topic_off_start')) ? eval($hook) : false;

	if (!($this_script == 'blog')){

		if (!($vbulletin->options['nominate_topic_on_off']) || $forumid == 0 || nominate_topic_in_array($forumid, $vbulletin->options['nominate_topic_forum_off'])){
			return true;
		}

		if (($vbulletin->options['nominate_topic_forum_first_all'] && !($postinfo['postid'] == $threadfirstpostid)) || (nominate_topic_in_array($forumid, $vbulletin->options['nominate_topic_forum_first']) && !($postinfo['postid'] == $threadfirstpostid))){
			return true;
		}

		if (!($this_script == 'showthread' || $this_script == 'showpost' || $this_script == '')){
			return true;
		}

		if ($vbulletin->options['nominate_topic_usergroup_getting']){
			if (is_member_of($postinfo, explode(",", $vbulletin->options['nominate_topic_usergroup_getting']))){
				return true;
			}
		}

		if ($vbulletin->options['nominate_topic_user_getting']){
			if (in_array($postinfo['userid'], explode(",", $vbulletin->options['nominate_topic_user_getting']))){
				return true;
			}
		}
	}
	else {
		if (!($vbulletin->options['nominate_topic_on_off'])){
			return true;
		}	

		if ($vbulletin->options['nominate_topic_usergroup_getting']){
			if (is_member_of($bloginfo, explode(",", $vbulletin->options['nominate_topic_usergroup_getting']))){
				return true;
			}
		}
		if ($vbulletin->options['nominate_topic_user_getting']){
			if (in_array($bloginfo['userid'], explode(",", $vbulletin->options['nominate_topic_user_getting']))){
				return true;
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_nominate_topic_off_end')) ? eval($hook) : false;

	return false;
}

function can_nominate_this_post($postinfo = array(), $bloginfo = array(), $threadisdeleted = 0, $check_security = false, $this_script = '', $securitytoken = ''){

	global $vbulletin;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_can_nominate_this_post_start')) ? eval($hook) : false;

	if (!($this_script == 'blog')){
		if ($postinfo['postid'] == 0 || $vbulletin->userinfo['userid'] == 0 || $postinfo['isdeleted'] || $threadisdeleted || (!($vbulletin->options['nominate_topic_poster_button']) && $postinfo['userid'] == $vbulletin->userinfo['userid'])){
			return false;
		}
	}
	else {
		if ($bloginfo['blogid'] == 0 || $vbulletin->userinfo['userid'] == 0 || (!($vbulletin->options['nominate_topic_poster_button']) && $bloginfo['userid'] == $vbulletin->userinfo['userid'])){
			return false;
		}
	}

	if ($vbulletin->options['nominate_topic_last_month']){

		$lastmonth = date("m")-1;
		$firstday_lastmonth = mktime(0, 0, 0, $lastmonth, 1,   date("Y"));
		$lastday_lastmonth = mktime(0, 0, 0, $lastmonth, date("t",$firstday_lastmonth),   date("Y"));

		if (($postinfo['dateline'] < $firstday_lastmonth) || ($postinfo['dateline'] > $lastday_lastmonth)) {
			return false;
		}
	}

	if (nominate_topic_in_array($vbulletin->userinfo['usergroupid'], $vbulletin->options['nominate_topic_usergroup_using']) || nominate_topic_in_array($vbulletin->userinfo['userid'], $vbulletin->options['nominate_topic_user_useing'])){
		return false;
	}

	if ($vbulletin->userinfo['posts'] < $vbulletin->options['nominate_topic_post_count_needed']){
		return false;
	}

	if ($vbulletin->options['nominate_topic_max_per_day']){
		global $count_nominations_so_far_today;

		if ($count_nominations_so_far_today === null){
			$count_nominations_so_far_today = $vbulletin->db->query_first("SELECT COUNT(*) AS total FROM " .TABLE_PREFIX. "nominate_topic WHERE userid = " . $vbulletin->userinfo['userid'] . " AND date > " . (TIMENOW - (60 * 60 * 24)) . "");
		}

		if ($vbulletin->options['nominate_topic_max_per_day'] <= $count_nominations_so_far_today['total']){
			return false;
		}
	}

	if ($vbulletin->options['nominate_topic_max_per_cycle']){
		global $count_nominations_so_far_cycle;

		if ($vbulletin->options['nominate_topic_week_month'] == 1){
			$cycle_days = 7;
		}
		else{
			if ($vbulletin->options['nominate_topic_week_month'] == 2){
				$cycle_days = 15;
			}
			else{
				$cycle_days = 30;
			}
		}
	
		if ($count_nominations_so_far_cycle === null){
			$count_nominations_so_far_cycle = $vbulletin->db->query_first("SELECT COUNT(*) AS total FROM " .TABLE_PREFIX. "nominate_topic WHERE userid = " . $vbulletin->userinfo['userid'] . " AND date > " . (TIMENOW - $cycle_days*(60 * 60 * 24)) . "");
		}

		if ($vbulletin->options['nominate_topic_max_per_cycle'] <= $count_nominations_so_far_cycle['total']){
			return false;
		}
	}

	if ($vbulletin->options['nominate_topic_days_old']){
		if (!($this_script == 'blog')){
			if ($TIMENOW > (($vbulletin->options['nominate_topic_days_old'] * 60 * 60 * 24) + $postinfo['dateline'])){
				return false;
			}
		}
		else {
			if ($TIMENOW > (($vbulletin->options['nominate_topic_days_old'] * 60 * 60 * 24) + $bloginfo['dateline'])){
				return false;
			}
		}
	}

	if (!($this_script == 'blog')){
		if ($postinfo['nominate_topic_award'] > 0){
			return false;
		}
	}
	else {
		if ($bloginfo['nominate_topic_award'] > 0){
			return false;
		}
	}

	if ($check_security && function_exists(verify_security_token)){
		if (!verify_security_token($securitytoken, $vbulletin->userinfo['securitytoken_raw'])){
			return false;
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_can_nominate_this_post_end')) ? eval($hook) : false;

	return true;

}

function can_delete_all_nominations(){

	global $vbulletin;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_can_delete_all_nominations_start')) ? eval($hook) : false;

	if ($vbulletin->userinfo['usergroupid'] == '6'){
		return true;
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_can_delete_all_nominations_end')) ? eval($hook) : false;

	return false;
}

function nominated_already($postinfo, $bloginfo, $this_script = '', $userid = 0, $fetch_again = false){

	global $vbulletin;

	if (!($this_script == 'blog')){
		$nominations = fetch_nominations($postinfo['postid'], '', $fetch_again, $this_script);
	}
	else {
		$nominations = fetch_nominations($bloginfo['blogid'], '', $fetch_again, $this_script);
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_nominated_already_start')) ? eval($hook) : false;

	$userid != 0 ? $userid = $userid : $userid = $vbulletin->userinfo['userid'];

	if (!($this_script == 'blog')){
		if ($postinfo['nominate_topic_amount'] && $nominations[$userid]){
			return true;
		}
	}
	else {
		if ($bloginfo['nominate_topic_amount'] && $nominations[$userid]){
			return true;
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_nominated_already_end')) ? eval($hook) : false;

	return false;
}

function show_nominations_date($forumid = 0){

	global $vbulletin;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_show_nominations_date_start')) ? eval($hook) : false;

	if ($vbulletin->options['nominate_topic_date_all'] && !nominate_topic_in_array($forumid, $vbulletin->options['nominate_topic_date_forum'])){
		return true;
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_show_nominations_date_end')) ? eval($hook) : false;

	return false;
}

function fetch_nominations($postid = 0, $postids = '', $fetch_again = false, $this_script = ''){

	global $vbulletin;
	static $cache, $act;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_fetch_nominations_start')) ? eval($hook) : false;

	if ((!($cache) && !($act)) || ($fetch_again)){
		$cache = array();

		if ($postids){
			$post_ids = "0$postids";
		}
		else{
			$post_ids = $postid;
		}

		if ($vbulletin->options['nominate_topic_use_musername']){
			$nominations = $vbulletin->db->query_read("SELECT * FROM " .TABLE_PREFIX. "nominate_topic AS nominate_topic INNER JOIN " .TABLE_PREFIX. "user AS user USING (userid) WHERE nominate_topic.postid IN (" . $post_ids . ") ORDER BY nominate_topic.username ASC");
		}
		else{
			$nominations = $vbulletin->db->query_read("SELECT * FROM " .TABLE_PREFIX. "nominate_topic WHERE postid IN (" . $post_ids . ") ORDER BY username ASC");
		}

		while ($nomination = $vbulletin->db->fetch_array($nominations)){
			$cache[$nomination['postid']][$nomination['userid']]['userid'] = $nomination['userid'];

			if ($vbulletin->options['nominate_topic_use_musername']){
				$cache[$nomination['postid']][$nomination['userid']]['username'] = fetch_musername($nomination);
			}
			else{
				$cache[$nomination['postid']][$nomination['userid']]['username'] = $nomination['username'];
			}

			$cache[$nomination['postid']][$nomination['userid']]['date'] = $nomination['date'];
			$cache[$nomination['postid']][$nomination['userid']]['postid'] = $nomination['postid'];

			if ($this_script == 'blog'){
				$cache[$nomination['postid']][$nomination['userid']]['is_blog'] = '1';
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_fetch_nominations_end')) ? eval($hook) : false;

	$act = true;
	return $cache[$postid];
}

function fetch_nominations_bit($forumid = 0, $nominations, $this_script = ''){

	global $vbulletin;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_fetch_nominations_bit_start')) ? eval($hook) : false;

	$number_rows = count($nominations);

	$cmpt=1;
	$show_usernames = $vbulletin->options[nominate_topic_display_username];

	if ($number_rows > 0){
		foreach ($nominations AS $nomination){
			if ($cmpt<$number_rows){
				$virg=",";
			}
			else{
				$virg="";
			}

			if ($this_script == 'blog'){
				$date_nomination = vbdate($vbulletin->options['dateformat'], $nomination['date'], true);
			}
			else {
				if (show_nominations_date($forumid)){
					$date_nomination = vbdate($vbulletin->options['dateformat'], $nomination['date'], true);
				}
			}

			eval('$liste_user .= " ' . fetch_template('nominate_topic_box_bit') . '";');
			$cmpt++;
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_fetch_nominations_bit_end')) ? eval($hook) : false;

	return $liste_user;
}

function fetch_nominate_topic_stamps_template($post, $bloginfo, $this_script = ''){

	global $vbulletin, $vbphrase, $stylevar;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_fetch_nominate_topic_stamps_template_start')) ? eval($hook) : false;

	if (!($this_script == 'blog')){
		if ($vbulletin->options['legacypostbit'])	{
			eval('$template = "' . fetch_template('nominate_topic_legacy_stamps') . '";');
		}
		else{
			eval('$template = "' . fetch_template('nominate_topic_stamps') . '";');
		}
	}
	else {
		eval('$template = "' . fetch_template('nominate_topic_blog_stamps') . '";');
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_fetch_nominate_topic_stamps_template_end')) ? eval($hook) : false;

	return $template;
}

function nominate_topic_get_nominate_box_title($post_award){

	global $vbulletin, $vbphrase;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_get_week_month_start')) ? eval($hook) : false;

	$now = time();
	$t = getdate($now);

	$day = date("j");
	$day_of_the_week = date("w");
	$days_in_month = date("t");
	$month = date("n");


	if ($post_award > 0) {
		$week_number = strftime("%V", $post_award);
		$month_name = strftime("%B", $post_award);
		$year_number = strftime("%Y", $post_award);

		if ($vbulletin->options['nominate_topic_week_month'] == 1){
			$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_award_title_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
		}
		else {
			if ($vbulletin->options['nominate_topic_week_month'] == 2){
				$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_award_title_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
			}
			else {
				$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_award_title_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
			}
		}
	}
	else {
		if ($vbulletin->options['nominate_topic_header_nextcyle'] == 1){
			if ($vbulletin->options['nominate_topic_week_month'] == 1){
				$nextWeek = $now + (7 * 24 * 60 * 60);
				$week_number = strftime("%V", $nextWeek);
				$month_name = strftime("%B", $nextWeek);
				$year_number = strftime("%Y", $nextWeek);
				$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
			}
			else {
				if ($vbulletin->options['nominate_topic_week_month'] == 2){
					if ($day < 15) {$fortnight = 2*$month;} else {$fortnight = 2*$month+1;}

					$twoWeeks = $now + (14 * 24 * 60 * 60);
					$week_number = strftime("%V", $twoWeeks);
					$month_name = strftime("%B", $twoWeeks);
					$year_number = strftime("%Y", $twoWeeks);
					$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
				}
				else {
					$next_month = mktime($t['hours'], $t['minutes'], $t['seconds'], $t['mon'] + 1, $t['mday'], $t['year']);
					$week_number = strftime("%V", $next_month);
					$month_name = strftime("%B", $next_month);
					$year_number = strftime("%Y", $next_month);
					$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
				}
			}
		}
		else {
			if ($vbulletin->options['nominate_topic_week_month'] == 1){
				$week_number = strftime("%V", $now);
				$month_name = strftime("%B", $now);
				$year_number = strftime("%Y", $now);
				$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_week'], $vbulletin->options['nominate_topic_contest_header'], $week_number, $month_name, $year_number);
			}
			else {
				if ($vbulletin->options['nominate_topic_week_month'] == 2){
					if ($day < 15) {$fortnight = 2*$month - 1;} else {$fortnight = 2*$month;}

					$twoWeeks = $now + (14 * 24 * 60 * 60);
					$week_number = strftime("%V", $twoWeeks);
					$month_name = strftime("%B", $twoWeeks);
					$year_number = strftime("%Y", $twoWeeks);
					$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_fortnight'], $vbulletin->options['nominate_topic_contest_header'], $fortnight, $week_number, $month_name, $year_number);
				}
				else {
					$week_number = strftime("%V", $now);
					$month_name = strftime("%B", $now);
					$year_number = strftime("%Y", $now);
					$nominate_box_title = construct_phrase($vbphrase['nominate_topic_nomination_thread_title_month'], $vbulletin->options['nominate_topic_contest_header'], $month_name, $year_number);
				}
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_get_week_month_end')) ? eval($hook) : false;

	return $nominate_box_title;
}

function fetch_nominate_topic_template($post, $bloginfo, $this_script= ''){

	global $vbulletin, $vbphrase, $stylevar;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_fetch_nominate_topic_template_start')) ? eval($hook) : false;

	$nominate_box_title = nominate_topic_get_nominate_box_title($post['nominate_topic_award']);

	if ($post['nominate_topic_award'] > 0){
		$nextNomination = $post['nominate_topic_award'] + (24 * 60 * 60 * $vbulletin->options['nominate_topic_waiting_time']);
		$nextNomination = $vbphrase['nominate_topic_can_enteronlyafter'] . strftime(" %A %d, %B, %Y", $nextNomination);
	}

	$show_usernames = $vbulletin->options[nominate_topic_display_username];

	if ($this_script == 'blog') {
		eval('$template = "' . fetch_template('nominate_topic_blog') . '";');
	}
	else {
		if ($vbulletin->options['legacypostbit'])	{
			eval('$template = "' . fetch_template('nominate_topic_postbit_legacy') . '";');
		}
		else{
			eval('$template = "' . fetch_template('nominate_topic_postbit') . '";');
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_fetch_nominate_topic_template_end')) ? eval($hook) : false;

	return $template;
}

function add_nomination($postinfo, $bloginfo, $ispost){

	global $vbulletin, $vbphrase;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_add_nominations_start')) ? eval($hook) : false;

	$now = time();

	if ($ispost){
		$vbulletin->db->query_write("
			INSERT INTO ". TABLE_PREFIX ."nominate_topic
				(userid, username, date, postid)
			VALUES
				('" . $vbulletin->userinfo['userid'] . "', '" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "', " . $now . ", " . $postinfo['postid'] .")
		");

		$nominated_post_title = $postinfo['title'];
		if (empty($nominated_post_title)) {
			$threadinfo = fetch_threadinfo($postinfo[threadid]); 
			$nominated_post_title = $threadinfo['title'];
		}
	}
	else {
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$vbulletin->db->query_write("
				INSERT INTO ". TABLE_PREFIX ."nominate_topic
					(userid, username, date, postid, is_blog)
				VALUES
					('" . $vbulletin->userinfo['userid'] . "', '" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "', " . $now . ", " . $bloginfo['blogid'] . ", '1')
			");

			$nominated_post_title = $bloginfo['title'];
		}
	}

	$set_user_made = 'nominate_topic_user_amount = 1 + nominate_topic_user_amount';
	$set_user_got = 'nominate_topic_nominated_times = 1 + nominate_topic_nominated_times';
	$set_post = 'nominate_topic_amount = 1 + nominate_topic_amount';

	if ($postinfo['nominate_topic_amount'] == 0){
		$set_user_got .= ', nominate_topic_nominated_posts = 1 + nominate_topic_nominated_posts';
	}

	$site_URL = $vbulletin->options[bburl];

	if ($ispost){
		if ($vbulletin->options['nominate_topic_reputation']){
			$vbulletin->db->query_write("
				INSERT IGNORE INTO ". TABLE_PREFIX ."reputation
					(postid, userid, reputation, whoadded, reason, dateline)
				VALUES
					('".$postinfo['postid']."', '".$postinfo['userid']."', '" . $vbulletin->options['nominate_topic_reputation'] . "', '" . $vbulletin->userinfo['userid'] . "', '$vbphrase[nominate_topic_nominated_post]', " . TIMENOW . ")
			");

			if ($vbulletin->db->affected_rows() != 0)	{
				$reputationlevel = $vbulletin->db->query_first_slave("
					SELECT reputationlevelid
 					FROM " . TABLE_PREFIX . "reputationlevel
					WHERE " . ($postinfo['reputation'] + $vbulletin->options['nominate_topic_reputation']) . "  >= minimumreputation
	  				ORDER BY minimumreputation DESC
					LIMIT 1");

				$set_user_got .= ", reputation = " . $vbulletin->options['nominate_topic_reputation'] . " + reputation, reputationlevelid = " . intval($reputationlevel['reputationlevelid']);
			}
		}
	}

	if ($vbulletin->options['nominate_topic_post_count']){
		$set_user_made .= ', posts = 1 + posts';
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET $set_user_made WHERE userid = '" . $vbulletin->userinfo['userid'] . "'");

	if ($ispost){
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET $set_user_got WHERE userid = '$postinfo[userid]'");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET $set_post WHERE postid = '$postinfo[postid]'");
		if ($vbulletin->options['nominate_topic_iconnominated']) {
			$icon_id = $vbulletin->options['nominate_topic_iconnominated'];
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET iconid = '$icon_id' WHERE postid = '$postinfo[postid]'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "thread SET iconid = '$icon_id' WHERE threadid = '$postinfo[threadid]'");
		}
	}
	else {
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET $set_user_got WHERE userid = '$bloginfo[userid]'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "blog SET $set_post WHERE blogid = '$bloginfo[blogid]'");
		}
	}

	// Update the poll on the receiving thread.

	$nominatetopicthread = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic_thread WHERE postid > '0'");
	$nb_rows = $vbulletin->db->num_rows($nominatetopicthread);

	if ($nb_rows != 0){
		$row = $vbulletin->db->fetch_array($nominatetopicthread);
		$nominationthread_pollid = $row['pollid'];
		$nominationthread_threadid = $row['threadid'];
		$nominationthread_postid = $row['postid'];

		// Process post & blog data
		$get_most_nominated = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE nominate_topic_amount > 0 AND visible = '1' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
		$nb_most_nominated = $vbulletin->db->num_rows($get_most_nominated);

		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$get_most_nominated_blog = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."blog WHERE nominate_topic_amount > 0 AND state = 'visible' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
			$nb_most_nominated_blog = $vbulletin->db->num_rows($get_most_nominated_blog);
		}

		$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
		$totalNominationsCount = 0;

		$nominatedposttitle[0] = $vbphrase['nominate_topic_awaiting_nominees'];
		$nominatedposttitle[$max_Poll_choices] = $vbphrase['nominate_topic_remaining_nominations'];

		$nominatedcount[0] = $nominatedcount[1] = $nominatedcount[2] = $nominatedcount[3] = $nominatedcount[4] = $nominatedcount[5] = $nominatedcount[6] = $nominatedcount[7] = $nominatedcount[8] = $nominatedcount[9] = 0;
		$site_URL = $vbulletin->options[bburl];

		if (($nb_most_nominated != 0) || ($nb_most_nominated_blog != 0)){

			$i = -1;

			if ($nb_most_nominated != 0) {
				$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
				while ($row = $vbulletin->db->fetch_array($get_most_nominated)){
					if ( $i < $max_Poll_choices - 1){
						$i++;

						$nominatedpost_threadid[$i] = $row['threadid'];
						$post_id = $row['postid'];
						$post_threadid = $row['threadid'];
						$nominatedpostid[$i] = $post_id;
						$nominatedpost_isblog[$i] = 0;

						$post_title = $row['title'];
						if (empty($post_title)) {
							$threadinfo = fetch_threadinfo($post_threadid); 
							$post_title = $threadinfo['title'];
						}

						$nominatedposttitle[$i] = "[post=".$post_id."]".$post_title."[/post]";
						$nominatedcount[$i] = $row['nominate_topic_amount'];
					}
					else{
						$i = $max_Poll_choices;
						$nominatedcount[$i] = $nominatedcount[$i] + $row['nominate_topic_amount'];
						if ($postinfo['postid'] == $row['postid']){
							$nominatedpostid[$i] = $row['postid'];
						}
					}

					if ($postinfo['postid'] == $row['postid']){
						$vote_option = $i;
					}

					$totalNominationsCount = $totalNominationsCount + $row['nominate_topic_amount'];
				}
			}

			if (($nb_most_nominated_blog != 0) AND ($vbulletin->options['nominate_topic_blog_on_off'])){
				while ($row = $vbulletin->db->fetch_array($get_most_nominated_blog)){

					$blog_id = $row['blogid'];
					$blog_title = $row['title'];
					$nt_amount = $row['nominate_topic_amount'];

					$j = 0;
					while (($nt_amount < $nominatedcount[$j]) AND ($j <= i)){$j++;}

					if ($j < $i+1) {
						for ($k = $i+1; $k > $j; $k--) {
							$nominatedpost_threadid[$k] = $nominatedpost_threadid[$k-1];
							$nominatedpostid[$k] = $nominatedpostid[$k-1];
							$nominatedpost_isblog[$k] = $nominatedpost_isblog[$k-1];
							$nominatedposttitle[$k] = $nominatedposttitle[$k-1];
							$nominatedcount[$k] = $nominatedcount[$k-1];
						}
					}

					$nominatedpost_threadid[$j] = $blog_id;
					$nominatedpostid[$j] = $blog_id;
					$nominatedpost_isblog[$j] = 1;
					$nominatedposttitle[$j] = "[url=".$site_URL."/blog.php?$session[sessionurl]b=".$blog_id."]Blog: ".$blog_title."[/url]";
					$nominatedcount[$j] = $nt_amount;

					if ( $i < $max_Poll_choices - 1){
						$i++;
					}
					else{
						$i = $max_Poll_choices;
						$nominatedcount[$i] = $nominatedcount[$i] + $row['nominate_topic_amount'];
						if ($bloginfo['blogid'] == $row['blogid']){
							$nominatedpostid[$i] = $row['blogid'];
						}
					}

					if ($bloginfo['blogid'] == $row['blogid']){
						$vote_option = $i;
					}

					$totalNominationsCount = $totalNominationsCount + $row['nominate_topic_amount'];
				}
			}

			for ($j = 0; $j < $max_Poll_choices; $j++) {
				$nominatedposttitle[$j] = str_replace("'", "\'", $nominatedposttitle[$j]);
			}

			$voters = $totalNominationsCount;
			$lastvote = $now;
			$poll_id = $nominationthread_pollid;
			$numberoptions = $i+1;
			$vote_option = $vote_option + 1;

			switch ($i) {
				case 0:
					$votes = $nominatedcount[0];
					$choices = $nominatedposttitle[0];
					break;
				case 1:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1];
					break;
				case 2:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2];
					break;
				case 3:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3];
					break;
				case 4:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4];
					break;
				case 5:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5];
					break;
				case 6:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6];
					break;
				case 7:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7];
					break;
				case 8:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7]."|||".$nominatedcount[8];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7]."|||".$nominatedposttitle[8];
					break;
				case 9:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7]."|||".$nominatedcount[8]."|||".$nominatedcount[9];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7]."|||".$nominatedposttitle[8]."|||".$nominatedposttitle[9];
					break;
			}

			$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "poll` SET `options`='$choices', `votes`='$votes', `numberoptions`='$numberoptions' , `voters`='$voters', `lastvote`='$lastvote' WHERE `pollid` = '$poll_id'");

			$user_id = $vbulletin->userinfo['userid'];
			$get_user_nominations = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE userid = '$user_id'");
			while ($user_nominee = $vbulletin->db->fetch_array($get_user_nominations)){
				$post_id = $user_nominee['postid'];

				if (!($ispost)){
					if ($vbulletin->options['nominate_topic_blog_on_off']){
						for ($j = 0; $j < $numberoptions; $j++) {
							if ($bloginfo['blogid'] == $post_id){
								$vote_option = $j+1;
							}
						}
					}
				}
				else {
					for ($j = 0; $j < $numberoptions; $j++) {
						if ($postinfo['postid'] == $post_id){
							$vote_option = $j+1;
						}
					}
				}

				if ($vote_option > 0){
					$get_pollvote = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."pollvote WHERE userid = '$user_id' AND pollid = '$poll_id' AND voteoption = '$vote_option' AND votetype ='$vote_option'");
					$nb_pollvote = $vbulletin->db->num_rows($get_pollvote);
					if ($nb_pollvote == 0){
						$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "pollvote (pollid,userid,votedate,voteoption,votetype) VALUES ('$poll_id','$user_id','$now','$vote_option','$vote_option')");
					}
				}
			}
		}

		// Add a new post for archiving nominations

		if (($vbulletin->options[nominate_topic_display_username]) && ($vbulletin->options['nominate_topic_archive_nominations'])){

			if (!($ispost)){
				if ($vbulletin->options['nominate_topic_blog_on_off']){
					$newThreadTitle = nominate_topic_get_nominate_box_title($bloginfo['nominate_topic_award']);
				}
			}
			else {
				$newThreadTitle = nominate_topic_get_nominate_box_title($postinfo['nominate_topic_award']);
			}

			$postusername = $vbulletin->db->escape_string($vbulletin->userinfo['username']); 
			$postuserid = $vbulletin->userinfo['userid']; 
			$posttitle = $nominated_post_title;

			if (!($ispost)){
				if ($vbulletin->options['nominate_topic_blog_on_off']){
					$blog_url = $site_URL . "/blog.php?$session[sessionurl]b=". $bloginfo['blogid'];
					$postpagetext = construct_phrase($vbphrase['nominate_topic_nominate_this_blog_message'], $blog_url, $nominated_post_title, $newThreadTitle);
				}
			}
			else {
				$postpagetext = construct_phrase($vbphrase['nominate_topic_nominate_this_post_message'], $postinfo['postid'], $nominated_post_title, $newThreadTitle);
			}

			$threadinfo = fetch_threadinfo($nominationthread_threadid); 
			$foruminfo = fetch_foruminfo($threadinfo['forumid']); 

			$postdm =& datamanager_init('Post', $vbulletin, $error_type, 'threadpost');
			$postdm->set_info('forum', $foruminfo);
			$postdm->set_info('thread', $threadinfo); 

			if (version_compare($vbulletin->options['templateversion'], '3.6.999', '>=')){
				$postdm->set_info('is_automated', true);
				$postdm->set_info('chop_title', true);
			}
			else {
				$postdm->set_info('skip_floodcheck', true);
				$postdm->set_info('skip_charcount', true);
				$postdm->set_info('skip_maximagescheck', true);
			}

			$postdm->set('threadid', $threadinfo['threadid']);
			$postdm->set('parentid', $threadinfo['firstpostid']);
			$postdm->set('iconid', 1);
			$postdm->set('userid', $postuserid);
			$postdm->set('title', $posttitle);
			$postdm->set('pagetext', $postpagetext);
			$postdm->set('visible', 1);
			$postdm->set('allowsmilie', 1);
			$postdm->set('showsignature', 1);
			$postdm->set('ipaddress', '');
			$postdm->set('dateline', $now);
			if ($postdm = $postdm->save()) {
				require_once(DIR . '/includes/functions_databuild.php'); 
				build_forum_counters($threadinfo['forumid']); 
				$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."postparsed WHERE `postid` = '$postdm'");
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_add_nominations_end')) ? eval($hook) : false;
}

function delete_nomination($postinfo, $bloginfo, $ispost, $userid, $remove_users_nominations_count = true){

	global $vbulletin, $vbphrase;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_delete_nomination_start')) ? eval($hook) : false;

	if ($ispost != 0){
		if (!(nominated_already($postinfo, '', '', $userid, true))){
			return false;
		}
	}
	else {
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			if (!(nominated_already('', $bloginfo, 'blog', $userid, true))){
				return false;
			}
		}
	}

	// Update the poll on the receiving thread by deleting user's vote.

	$now = TIMENOW;

	$nominatetopicthread = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic_thread WHERE postid > '0'");
	$nb_rows = $vbulletin->db->num_rows($nominatetopicthread);

	if ($nb_rows != 0){
		$row = $vbulletin->db->fetch_array($nominatetopicthread);
		$nominationthread_pollid = $row['pollid'];
		$nominationthread_threadid = $row['threadid'];
		$nominationthread_postid = $row['postid'];
		$lastvote = $now;

		$get_most_nominated = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE nominate_topic_amount > 0 AND visible = '1' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
		$nb_most_nominated = $vbulletin->db->num_rows($get_most_nominated);

		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$get_most_nominated_blog = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."blog WHERE nominate_topic_amount > 0 AND state = 'visible' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
			$nb_most_nominated_blog = $vbulletin->db->num_rows($get_most_nominated_blog);
		}

		$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
		$totalNominationsCount = 0;
		$nominatedposttitle[0] = $vbphrase['nominate_topic_awaiting_nominees'];
		$nominatedposttitle[$max_Poll_choices] = $vbphrase['nominate_topic_remaining_nominations'];
		$nominatedcount[0] = $nominatedcount[1] = $nominatedcount[2] = $nominatedcount[3] = $nominatedcount[4] = $nominatedcount[5] = $nominatedcount[6] = $nominatedcount[7] = $nominatedcount[8] = $nominatedcount[9] = 0;

		$site_URL = $vbulletin->options[bburl];

		if (($nb_most_nominated != 0) || ($nb_most_nominated_blog != 0)){

			$i = -1;

			if ($nb_most_nominated != 0){

				while ($row = $vbulletin->db->fetch_array($get_most_nominated)){
					if ( $i < $max_Poll_choices - 1){
						$i++;
						$nominatedcount[$i] = $row['nominate_topic_amount'];
					}
					else{
						$i = $max_Poll_choices;
					}

					if (($ispost) && ($postinfo['postid'] == $row['postid'])){
						$vote_option = $i;
					}
				}
			}

			if (($nb_most_nominated_blog != 0) AND ($vbulletin->options['nominate_topic_blog_on_off'])){
				while ($row = $vbulletin->db->fetch_array($get_most_nominated_blog)){

					$blog_id = $row['blogid'];
					$blog_title = $row['title'];
					$nt_amount = $row['nominate_topic_amount'];

					$j = 0;
					while (($nt_amount < $nominatedcount[$j]) AND ($j <= i)){$j++;}

					if ($j < $i+1) {
						for ($k = $i+1; $k > $j; $k--) {
							$nominatedcount[$k] = $nominatedcount[$k-1];
						}
					}

					$nominatedcount[$j] = $nt_amount;

					if ( $i < $max_Poll_choices - 1){
						$i++;
					}
					else{
						$i = $max_Poll_choices;
					}

					if (!($ispost) && ($bloginfo['blogid'] == $row['blogid'])){
						$vote_option = $i;
					}

				}
			}

			$poll_id = $nominationthread_pollid;
			$vote_option = $vote_option + 1;
			$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."pollvote WHERE pollid = '$poll_id' AND userid = '$userid' AND voteoption = '$vote_option'");
		}

		// Delete archived post from the archived nominations thread.

		if (($vbulletin->options[nominate_topic_display_username]) && ($vbulletin->options['nominate_topic_archive_nominations'])){

			if (!($ispost)){
				if ($vbulletin->options['nominate_topic_blog_on_off']){
					$getinfo = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE postid = '$bloginfo[blogid]' AND userid = '$userid' AND is_blog = '1'");
				}
			}
			else {
				$getinfo = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE postid = '$postinfo[postid]' AND userid = '$userid' AND is_blog = '0'");
			}
			$get_info = $vbulletin->db->fetch_array($getinfo);
			$post_dateline = $get_info['date'];

			$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."post WHERE threadid = '$nominationthread_threadid' AND userid = '$userid' AND dateline = '$post_dateline'");
			$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."postparsed WHERE `postid` = '$nominationthread_postid'");
		}
	}

	if (!($ispost)){
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."nominate_topic WHERE postid = '$bloginfo[blogid]' AND userid = '$userid' AND is_blog = '1'");
		}
	}
	else {
		$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."nominate_topic WHERE postid = '$postinfo[postid]' AND userid = '$userid' AND is_blog = '0'");
	}

	if ($remove_users_nominations_count == true || $vbulletin->options['nominate_topic_delete_remove_nominations_count']){
		$set_user_made = 'nominate_topic_user_amount = nominate_topic_user_amount - 1';
		$set_user_got = "nominate_topic_nominated_times = nominate_topic_nominated_times - 1";
	}
	else{
		$set_user_made = 'nominate_topic_user_amount = nominate_topic_user_amount';
		$set_user_got = "nominate_topic_nominated_times = nominate_topic_nominated_times";
	}
	
	$set_post = 'nominate_topic_amount = nominate_topic_amount - 1';

	if ($postinfo[nominate_topic_amount] == 1 && ($remove_users_nominations_count == true || $vbulletin->options['nominate_topic_delete_remove_nominations_count'])){
		$set_user_got .= ', nominate_topic_nominated_posts = nominate_topic_nominated_posts - 1';
	}

	if ($vbulletin->options['nominate_topic_post_count'] && ($remove_users_nominations_count == true || $vbulletin->options['nominate_topic_delete_remove_nominations_count'])){
		$set_user_made .= ', posts = posts - 1';
	}

	if ($ispost){
		if ($vbulletin->options['nominate_topic_reputation'] && ($remove_users_nominations_count == true || $vbulletin->options['nominate_topic_delete_remove_nominations_count'])){
			$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."reputation WHERE postid = '$postinfo[postid]' AND whoadded = '$userid' AND reason = '$vbphrase[nominate_topic_nominated_post]'");

			if ($vbulletin->db->affected_rows() != 0){
				$set_user_got .= ", reputation = reputation - ". $vbulletin->options[nominate_topic_reputation] ."";
			}
		}

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET $set_post WHERE postid = '$postinfo[postid]'");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET $set_user_got WHERE userid = '$postinfo[userid]'");

		if ($vbulletin->options['nominate_topic_iconnominated']) {
			$icon_id = $vbulletin->options['nominate_topic_iconnominated'];
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET iconid = '0' WHERE postid = '$postinfo[postid]'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "thread SET iconid = '0' WHERE threadid = '$postinfo[threadid]'");
		}

	}
	else {
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "blog SET $set_post WHERE blogid = '$bloginfo[blogid]'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET $set_user_got WHERE userid = '$bloginfo[userid]'");
		}
	}

	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET $set_user_made WHERE userid = '$userid'");

	// Update the poll on the receiving thread by displaying resulting votes.

	if ($nb_rows != 0){

		$get_most_nominated = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE nominate_topic_amount > 0 AND visible = '1' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
		$nb_most_nominated = $vbulletin->db->num_rows($get_most_nominated);

		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$get_most_nominated_blog = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."blog WHERE nominate_topic_amount > 0 AND state = 'visible' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
			$nb_most_nominated_blog = $vbulletin->db->num_rows($get_most_nominated_blog);
		}

		$nominatedcount[0] = 0;

		$nominatedposttitle[0] = $vbphrase['nominate_topic_awaiting_nominees'];
		$nominatedposttitle[$max_Poll_choices] = $vbphrase['nominate_topic_remaining_nominations'];
		$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
		$totalNominationsCount = 0;
		$nominatedcount[0] = $nominatedcount[1] = $nominatedcount[2] = $nominatedcount[3] = $nominatedcount[4] = $nominatedcount[5] = $nominatedcount[6] = $nominatedcount[7] = $nominatedcount[8] = $nominatedcount[9] = 0;
		$site_URL = $vbulletin->options[bburl];

		if (($nb_most_nominated != 0) || ($nb_most_nominated_blog != 0)){

			$i = -1;

			if ($nb_most_nominated != 0) {
				$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
				while ($row = $vbulletin->db->fetch_array($get_most_nominated)){
					if ( $i < $max_Poll_choices - 1){
						$i++;

						$nominatedpost_threadid[$i] = $row['threadid'];
						$post_id = $row['postid'];
						$post_threadid = $row['threadid'];
						$nominatedpostid[$i] = $post_id;
						$nominatedpost_isblog[$i] = 0;

						$post_title = $row['title'];
						if (empty($post_title)) {
							$threadinfo = fetch_threadinfo($post_threadid); 
							$post_title = $threadinfo['title'];
						}

						$nominatedposttitle[$i] = "[post=".$post_id."]".$post_title."[/post]";
						$nominatedcount[$i] = $row['nominate_topic_amount'];
					}
					else{
						$i = $max_Poll_choices;
						$nominatedcount[$i] = $nominatedcount[$i] + $row['nominate_topic_amount'];
						if ($postinfo['postid'] == $row['postid']){
							$nominatedpostid[$i] = $row['postid'];
						}
					}

					if (($ispost) && ($postinfo['postid'] == $row['postid'])){
						$vote_option = $i;
					}

					$totalNominationsCount = $totalNominationsCount + $row['nominate_topic_amount'];
				}
			}

			if (($nb_most_nominated_blog != 0) AND ($vbulletin->options['nominate_topic_blog_on_off'])){
				while ($row = $vbulletin->db->fetch_array($get_most_nominated_blog)){

					$blog_id = $row['blogid'];
					$blog_title = $row['title'];
					$nt_amount = $row['nominate_topic_amount'];

					$j = 0;
					while (($nt_amount < $nominatedcount[$j]) AND ($j <= i)){$j++;}

					if ($j < $i+1) {
						for ($k = $i+1; $k > $j; $k--) {
							$nominatedpost_threadid[$k] = $nominatedpost_threadid[$k-1];
							$nominatedpostid[$k] = $nominatedpostid[$k-1];
							$nominatedpost_isblog[$k] = $nominatedpost_isblog[$k-1];
							$nominatedposttitle[$k] = $nominatedposttitle[$k-1];
							$nominatedcount[$k] = $nominatedcount[$k-1];
						}
					}

					$nominatedpost_threadid[$j] = $blog_id;
					$nominatedpostid[$j] = $blog_id;
					$nominatedpost_isblog[$j] = 1;
					$nominatedposttitle[$j] = "[url=".$site_URL."/blog.php?$session[sessionurl]b=".$blog_id."]Blog: ".$blog_title."[/url]";
					$nominatedcount[$j] = $nt_amount;

					if ( $i < $max_Poll_choices - 1){
						$i++;
					}
					else{
						$i = $max_Poll_choices;
						$nominatedcount[$i] = $nominatedcount[$i] + $row['nominate_topic_amount'];
						if ($bloginfo['blogid'] == $row['blogid']){
							$nominatedpostid[$i] = $row['blogid'];
						}
					}

					if (!($ispost) && ($bloginfo['blogid'] == $row['blogid'])){
						$vote_option = $i;
					}

					$totalNominationsCount = $totalNominationsCount + $row['nominate_topic_amount'];
				}
			}

			for ($j = 0; $j < $max_Poll_choices; $j++) {
				$nominatedposttitle[$j] = str_replace("'", "\'", $nominatedposttitle[$j]);
			}

			$voters = $totalNominationsCount;
			$numberoptions = $i+1;

			switch ($i) {
				case 0:
					$votes = $nominatedcount[0];
					$choices = $nominatedposttitle[0];
					break;
				case 1:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1];
					break;
				case 2:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2];
					break;
				case 3:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3];
					break;
				case 4:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4];
					break;
				case 5:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5];
					break;
				case 6:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6];
					break;
				case 7:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7];
					break;
				case 8:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7]."|||".$nominatedcount[8];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7]."|||".$nominatedposttitle[8];
					break;
				case 9:
					$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7]."|||".$nominatedcount[8]."|||".$nominatedcount[9];
					$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7]."|||".$nominatedposttitle[8]."|||".$nominatedposttitle[9];
					break;
			}

			$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "poll` SET `options`='$choices', `votes`='$votes', `numberoptions`='$numberoptions' , `voters`='$voters', `lastvote`='$lastvote' WHERE `pollid` = '$nominationthread_pollid'");
		}
		else {
			$choices = $nominatedposttitle[0];
			$votes = $nominatedcount[0];
			$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "poll` SET `options`='$choices', `votes`='$votes', `numberoptions`='0' , `voters`='0', `lastvote`='$lastvote' WHERE `pollid` = '$nominationthread_pollid'");
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_delete_nomination_end')) ? eval($hook) : false;

	return true;
}

function delete_all_nominations($postinfo, $bloginfo, $ispost, $remove_users_nominations_count = true){

	global $vbulletin, $vbphrase;

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_delete_all_nominations_start')) ? eval($hook) : false;

	$now = TIMENOW;

	$ContestHeader = $vbulletin->options['nominate_topic_contest_header'];

	if (!($ispost)){
		if ($vbulletin->options['nominate_topic_blog_on_off']){
			$nominated_post_id = $bloginfo[blogid];
			$nominations=$vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE postid='$bloginfo[blogid]' AND is_blog='1' ORDER BY username");
		}
	}
	else {
		$nominated_post_id = $postinfo[postid];
		$nominations=$vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic WHERE postid='$postinfo[postid]' AND is_blog='0' ORDER BY username");
	}

	$nb=$vbulletin->db->num_rows($nominations);

	if ($nb != 0){
		// Update the poll on the receiving thread by deleting user's vote.
		$nominatetopicthread = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."nominate_topic_thread WHERE postid > '0'");
		$nb_rows = $vbulletin->db->num_rows($nominatetopicthread);

		if ($nb_rows != 0){
			$row = $vbulletin->db->fetch_array($nominatetopicthread);
			$nominationthread_pollid = $row['pollid'];
			$nominationthread_threadid = $row['threadid'];
			$nominationthread_postid = $row['postid'];

			while ($nomination = $vbulletin->db->fetch_array($nominations)){
				$nomination_userids[] = $nomination['userid'];

				$user_id = $nomination['userid'];
				$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."pollvote WHERE pollid = '$nominationthread_pollid' AND userid = '$user_id'");

				// Delete archived post from the archived nominations thread.

				if (($vbulletin->options[nominate_topic_display_username]) && ($vbulletin->options['nominate_topic_archive_nominations'])){
					$post_dateline = $nomination['date'];
					$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."post WHERE threadid = '$nominationthread_threadid' AND userid = '$user_id' AND dateline = '$post_dateline'");
				}
			}
			$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."postparsed WHERE `postid` = '$nominationthread_postid'");
		}

		if (!($ispost)){
			if ($vbulletin->options['nominate_topic_blog_on_off']){
				$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."nominate_topic WHERE postid = '$bloginfo[blogid]' AND is_blog = '1'");
			}
		}
		else {
			$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."nominate_topic WHERE postid='$postinfo[postid]' AND is_blog = '0'");
		}

		if ($remove_users_nominations_count == true || $vbulletin->options['nominate_topic_delete_remove_nominations_count']){
			$set_user_made = 'nominate_topic_user_amount = nominate_topic_user_amount - 1';
			$set_user_got = "nominate_topic_nominated_times = nominate_topic_nominated_times - $nb, nominate_topic_nominated_posts = nominate_topic_nominated_posts - 1";
		}
		else{
			$set_user_made = 'nominate_topic_user_amount = nominate_topic_user_amount';
			$set_user_got = "nominate_topic_nominated_times = nominate_topic_nominated_times, nominate_topic_nominated_posts = nominate_topic_nominated_posts";
		}

		$set_post = 'nominate_topic_amount = 0';
		$postinfo['nominate_topic_amount'] = 0;

		if ($ispost){
			if ($vbulletin->options['nominate_topic_reputation'] && ($remove_users_nominations_count == true || $vbulletin->options['nominate_topic_delete_remove_nominations_count'])){
				$vbulletin->db->query_write("DELETE FROM ". TABLE_PREFIX ."reputation WHERE postid = '$postinfo[postid]' AND reason = '$vbphrase[nominate_topic_nominated_post]'");

				if ($vbulletin->db->affected_rows() != 0){
					$total_rep_got = $vbulletin->options['nominate_topic_reputation'] * $nb;
					$set_user_got .= ", reputation = reputation - $total_rep_got";
				}
			}
		}

		if ($vbulletin->options['nominate_topic_post_count'] && ($remove_users_nominations_count == true || $vbulletin->options['nominate_topic_delete_remove_nominations_count'])){
			$set_user_made .= ', posts = posts - 1';
		}

		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET $set_user_made WHERE userid IN (".implode(",",$nomination_userids).")");

		if ($ispost){
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET $set_post WHERE postid = '$postinfo[postid]'");
			$vbulletin->db->query_write(" UPDATE " . TABLE_PREFIX . "user SET $set_user_got WHERE userid = '$postinfo[userid]'");
			if ($vbulletin->options['nominate_topic_iconnominated']) {
				$icon_id = $vbulletin->options['nominate_topic_iconnominated'];
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET iconid = '0' WHERE postid = '$postinfo[postid]'");
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "thread SET iconid = '0' WHERE threadid = '$postinfo[threadid]'");
			}
		}
		else {
			if ($vbulletin->options['nominate_topic_blog_on_off']){
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "blog SET $set_post WHERE blogid = '$bloginfo[blogid]'");
				$vbulletin->db->query_write(" UPDATE " . TABLE_PREFIX . "user SET $set_user_got WHERE userid = '$bloginfo[userid]'");
			}
		}

		// Update the poll on the receiving thread by displaying resulting votes.

		if ($nb_rows != 0){
			$get_most_nominated = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."post WHERE nominate_topic_amount > 0 AND visible = '1' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
			$nb_most_nominated = $vbulletin->db->num_rows($get_most_nominated);

			if ($vbulletin->options['nominate_topic_blog_on_off']){
				$get_most_nominated_blog = $vbulletin->db->query_read("SELECT * FROM ". TABLE_PREFIX ."blog WHERE nominate_topic_amount > 0 AND state = 'visible' AND nominate_topic_award = '0' ORDER BY nominate_topic_amount DESC");
				$nb_most_nominated_blog = $vbulletin->db->num_rows($get_most_nominated_blog);
			}

			$nominatedcount[0] = 0;

			$nominatedposttitle[0] = $vbphrase['nominate_topic_awaiting_nominees'];
			$nominatedposttitle[$max_Poll_choices] = $vbphrase['nominate_topic_remaining_nominations'];
			$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
			$totalNominationsCount = 0;
			$nominatedcount[0] = $nominatedcount[1] = $nominatedcount[2] = $nominatedcount[3] = $nominatedcount[4] = $nominatedcount[5] = $nominatedcount[6] = $nominatedcount[7] = $nominatedcount[8] = $nominatedcount[9] = 0;
			$site_URL = $vbulletin->options[bburl];

			if (($nb_most_nominated != 0) || ($nb_most_nominated_blog != 0)){

				$i = -1;

				if ($nb_most_nominated != 0) {
					$max_Poll_choices = $vbulletin->options['nominate_topic_max_per_poll'];
					while ($row = $vbulletin->db->fetch_array($get_most_nominated)){
						if ( $i < $max_Poll_choices - 1){
							$i++;

							$nominatedpost_threadid[$i] = $row['threadid'];
							$post_id = $row['postid'];
							$post_threadid = $row['threadid'];
							$nominatedpostid[$i] = $post_id;
							$nominatedpost_isblog[$i] = 0;

							$post_title = $row['title'];
							if (empty($post_title)) {
								$threadinfo = fetch_threadinfo($post_threadid); 
								$post_title = $threadinfo['title'];
							}

							$nominatedposttitle[$i] = "[post=".$post_id."]".$post_title."[/post]";
							$nominatedcount[$i] = $row['nominate_topic_amount'];
						}
						else{
							$i = $max_Poll_choices;
							$nominatedcount[$i] = $nominatedcount[$i] + $row['nominate_topic_amount'];
							if ($postinfo['postid'] == $row['postid']){
								$nominatedpostid[$i] = $row['postid'];
							}
						}

						if (($ispost) && ($postinfo['postid'] == $row['postid'])){
							$vote_option = $i;
						}

						$totalNominationsCount = $totalNominationsCount + $row['nominate_topic_amount'];
					}
				}

				if (($nb_most_nominated_blog != 0) AND ($vbulletin->options['nominate_topic_blog_on_off'])){
					while ($row = $vbulletin->db->fetch_array($get_most_nominated_blog)){

						$blog_id = $row['blogid'];
						$blog_title = $row['title'];
						$nt_amount = $row['nominate_topic_amount'];

						$j = 0;
						while (($nt_amount < $nominatedcount[$j]) AND ($j <= i)){$j++;}

						if ($j < $i+1) {
							for ($k = $i+1; $k > $j; $k--) {
								$nominatedpost_threadid[$k] = $nominatedpost_threadid[$k-1];
								$nominatedpostid[$k] = $nominatedpostid[$k-1];
								$nominatedpost_isblog[$k] = $nominatedpost_isblog[$k-1];
								$nominatedposttitle[$k] = $nominatedposttitle[$k-1];
								$nominatedcount[$k] = $nominatedcount[$k-1];
							}
						}

						$nominatedpost_threadid[$j] = $blog_id;
						$nominatedpostid[$j] = $blog_id;
						$nominatedpost_isblog[$j] = 1;
						$nominatedposttitle[$j] = "[url=".$site_URL."/blog.php?$session[sessionurl]b=".$blog_id."]Blog: ".$blog_title."[/url]";
						$nominatedcount[$j] = $nt_amount;

						if ( $i < $max_Poll_choices - 1){
							$i++;
						}
						else{
							$i = $max_Poll_choices;
							$nominatedcount[$i] = $nominatedcount[$i] + $row['nominate_topic_amount'];
							if ($bloginfo['blogid'] == $row['blogid']){
								$nominatedpostid[$i] = $row['blogid'];
							}
						}

						if (!($ispost) && ($bloginfo['blogid'] == $row['blogid'])){
							$vote_option = $i;
						}

						$totalNominationsCount = $totalNominationsCount + $row['nominate_topic_amount'];
					}
				}

				for ($j = 0; $j < $i; $j++) {
					$nominatedposttitle[$j] = str_replace("'", "\'", $nominatedposttitle[$j]);
				}

				$voters = $totalNominationsCount;
				$numberoptions = $i+1;

				switch ($i) {
					case 0:
						$votes = $nominatedcount[0];
						$choices = $nominatedposttitle[0];
						break;
					case 1:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1];
						break;
					case 2:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2];
						break;
					case 3:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3];
						break;
					case 4:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4];
						break;
					case 5:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5];
						break;
					case 6:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6];
						break;
					case 7:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7];
						break;
					case 8:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7]."|||".$nominatedcount[8];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7]."|||".$nominatedposttitle[8];
						break;
					case 9:
						$votes = $nominatedcount[0]."|||".$nominatedcount[1]."|||".$nominatedcount[2]."|||".$nominatedcount[3]."|||".$nominatedcount[4]."|||".$nominatedcount[5]."|||".$nominatedcount[6]."|||".$nominatedcount[7]."|||".$nominatedcount[8]."|||".$nominatedcount[9];
						$choices = $nominatedposttitle[0]."|||".$nominatedposttitle[1]."|||".$nominatedposttitle[2]."|||".$nominatedposttitle[3]."|||".$nominatedposttitle[4]."|||".$nominatedposttitle[5]."|||".$nominatedposttitle[6]."|||".$nominatedposttitle[7]."|||".$nominatedposttitle[8]."|||".$nominatedposttitle[9];
						break;
				}

				$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "poll` SET `options`='$choices', `votes`='$votes', `numberoptions`='$numberoptions' , `voters`='$voters', `lastvote`='$lastvote' WHERE `pollid` = '$nominationthread_pollid'");
			}
		}
		else {
			$choices = $nominatedposttitle[0];
			$votes = $nominatedcount[0];
			$vbulletin->db->query_write("UPDATE `" . TABLE_PREFIX . "poll` SET `options`='$choices', `votes`='$votes', `numberoptions`='0' , `voters`='0', `lastvote`='$lastvote' WHERE `pollid` = '$nominationthread_pollid'");
		}
	}

	($hook = vBulletinHook::fetch_hook('nominate_topic_function_delete_all_nominations_end')) ? eval($hook) : false;
}

function nominate_topic_in_array($number = 0, $array = 0){

	$array_split = explode(",", $array); 

	foreach ($array_split AS $array_number){
		if ($number == $array_number){
			return true; 
		} 
	} 
	return false;
}

function nominate_topic_check_security($securitytoken = ''){

	global $vbulletin;

	if ($securitytoken !== $vbulletin->userinfo['securitytoken']){
		
	}
}
?>